/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.evertree.lettres.Game;
import org.evertree.lettres.piece.Block;
import org.evertree.lettres.resource.HighScores;
import org.evertree.lettres.resource.Icons;
import org.evertree.lettres.resource.MessageLine;
import org.evertree.lettres.resource.Parameters;
import org.evertree.lettres.resource.SoundTrack;
import org.evertree.lettres.resource.Sounds;
import org.evertree.lettres.ui.BlinkingTimer;
import org.evertree.lettres.ui.InputHandler;
import org.evertree.lettres.ui.MainCanvas;
import org.evertree.lettres.ui.NextPieceCanvas;

public class UserInterface
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("###,###,###,##0");
    private Game game;
    private MainCanvas mainCanvas;
    private NextPieceCanvas nextPieceCanvas;
    private InputHandler inputHandler;
    private JLabel level;
    private JLabel lines;
    private JLabel score;
    private JLabel[] hiScoresName;
    private JLabel[] hiScoresValue;
    private BlinkingTimer levelTimer;
    private BlinkingTimer scoreTimer;
    private SoundTrack soundTrack;

    public UserInterface(Game game) {
        super("Lettres " + Parameters.LETTRES_VERSION);
        this.game = game;
        this.inputHandler = new InputHandler(game);
        this.configureWindow();
        this.buildContentPanel(this.getContentPane());
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.levelTimer = new BlinkingTimer(this.level);
        this.scoreTimer = new BlinkingTimer(this.score);
        this.soundTrack = new SoundTrack();
        this.nextPieceCanvas.paint();
        this.mainCanvas.requestFocus();
    }

    public void paint() {
        this.mainCanvas.paint();
        this.nextPieceCanvas.paint();
    }

    public void paintNext() {
        this.nextPieceCanvas.paint();
    }

    public void paintLabels() {
        this.level.setText(this.formatNumber(this.game.getLevel()));
        this.lines.setText(this.formatNumber(this.game.getLines()));
        this.score.setText(this.formatNumber(this.game.getScore()));
    }

    public void paintHighScores() {
        HighScores highScores = this.game.getHighScores();
        for (int i = 0; i < 5; ++i) {
            if (highScores.getNames()[i] != null) {
                this.hiScoresName[i].setText(highScores.getNames()[i]);
                this.hiScoresValue[i].setText(this.formatNumber(highScores.getValues()[i]));
                continue;
            }
            this.hiScoresName[i].setText("");
            this.hiScoresValue[i].setText("");
        }
    }

    public void playDeleteLines(List<Integer> lines) {
        if (Sounds.disappearClip != null) {
            Sounds.disappearClip.setFramePosition(0);
            Sounds.disappearClip.stop();
            Sounds.disappearClip.start();
        }
        long animationStart = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        while (now - animationStart < Parameters.VANISH_ANIMATION_DURATION) {
            double brightness = (double)(-1L * (now - animationStart)) / (double)Parameters.VANISH_ANIMATION_DURATION.longValue();
            Block[][] blocks = this.game.getBlocks();
            for (int line = 0; line < blocks.length; ++line) {
                if (!lines.contains(line)) continue;
                for (int column = 0; column < blocks[line].length; ++column) {
                    Block block = blocks[line][column];
                    if (block == null) continue;
                    block.setBrightness(brightness);
                    block.setFontBrightness(brightness);
                }
            }
            this.mainCanvas.paint();
            try {
                Thread.sleep(1000 / Parameters.FPS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            now = System.currentTimeMillis();
        }
    }

    public void playWordAnimation(Block[] blocks) {
        if (Sounds.wordFoundClip != null) {
            Sounds.wordFoundClip.setFramePosition(0);
            Sounds.wordFoundClip.stop();
            Sounds.wordFoundClip.start();
        }
        Block[][] blockArray = this.game.getBlocks();
        int n = blockArray.length;
        for (int i = 0; i < n; ++i) {
            Block[] blockLine;
            for (Block block : blockLine = blockArray[i]) {
                if (block == null) continue;
                block.setBrightness(-0.6);
                block.setFontBrightness(-0.6);
            }
        }
        long duration = Parameters.LIGHT_ANIMATION_DURATION;
        long animationStart = System.currentTimeMillis();
        long past = System.currentTimeMillis() - animationStart;
        while (past < duration) {
            double brightness = 0.0;
            brightness = past < duration / 2L ? (double)past / ((double)duration / 2.5) : (double)(duration - past) / ((double)duration / 2.5);
            for (Block block : blocks) {
                if (block == null) continue;
                block.setFontBrightness(brightness);
            }
            this.mainCanvas.paint();
            try {
                Thread.sleep(1000 / Parameters.FPS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            past = System.currentTimeMillis() - animationStart;
        }
        Block[][] blockArray2 = this.game.getBlocks();
        int n2 = blockArray2.length;
        for (int i = 0; i < n2; ++i) {
            Block[] blockLine;
            for (Block block : blockLine = blockArray2[i]) {
                if (block == null) continue;
                block.setBrightness(0.0);
                block.setFontBrightness(0.0);
            }
        }
        this.mainCanvas.paint();
    }

    public void playBlocksShowing(List<Block> blocks) {
        if (Sounds.wordFoundClip != null) {
            Sounds.wordFoundClip.setFramePosition(0);
            Sounds.wordFoundClip.stop();
            Sounds.wordFoundClip.start();
        }
        for (Block block : blocks) {
            block.setBrightness(-1.0);
            block.setFontBrightness(-1.0);
        }
        long animationStart = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        while (now - animationStart < Parameters.LIGHT_ANIMATION_DURATION) {
            double brightness = -1.0 + (double)(now - animationStart) / (double)Parameters.LIGHT_ANIMATION_DURATION.longValue();
            for (Block block : blocks) {
                block.setBrightness(brightness);
                block.setFontBrightness(brightness);
            }
            this.mainCanvas.paint();
            try {
                Thread.sleep(1000 / Parameters.FPS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            now = System.currentTimeMillis();
        }
    }

    public void playGameOver() {
        this.soundTrack.stop();
        if (Sounds.gameoverClip != null) {
            Sounds.gameoverClip.setFramePosition(0);
            Sounds.gameoverClip.stop();
            Sounds.gameoverClip.start();
        }
        Block[][] blockArray = this.game.getBlocks();
        int n = blockArray.length;
        for (int i = 0; i < n; ++i) {
            Block[] blockLine;
            for (Block block : blockLine = blockArray[i]) {
                if (block == null) continue;
                block.setBrightness(-0.7);
                block.setFontBrightness(-0.7);
            }
        }
        if (this.game.getDropping() != null) {
            this.game.getDropping().moveRight();
            this.game.getDropping().moveRight();
            this.game.getDropping().moveRight();
        }
        this.paint();
    }

    public void playLevelUp() {
        if (Sounds.levelUpClip != null) {
            Sounds.levelUpClip.setFramePosition(0);
            Sounds.levelUpClip.stop();
            Sounds.levelUpClip.start();
        }
        this.levelTimer.reset();
        this.levelTimer.start();
        this.soundTrack.nextSong();
    }

    public void playScoreUp() {
        if (Sounds.levelUpClip != null) {
            Sounds.levelUpClip.setFramePosition(0);
            Sounds.levelUpClip.stop();
            Sounds.levelUpClip.start();
        }
        this.scoreTimer.reset();
        this.scoreTimer.start();
    }

    public void playBomb(int x, int y) {
        if (Sounds.gameoverClip != null) {
            Sounds.gameoverClip.setFramePosition(0);
            Sounds.gameoverClip.stop();
            Sounds.gameoverClip.start();
        }
        long duration = Parameters.BOMB_ANIMATION_DURATION;
        long animationStart = System.currentTimeMillis();
        long past = System.currentTimeMillis() - animationStart;
        int factor = 0;
        while (past < duration) {
            factor = past < duration / 2L ? (int)((double)past / ((double)duration / 2.0) * 511.0) : (int)((double)(duration - past) / ((double)duration / 2.0) * 511.0);
            this.paintBomb1(x, y, factor);
            this.paintBomb2(x, y, factor);
            this.paintBomb3(x, y, factor);
            try {
                Thread.sleep(1000 / Parameters.FPS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            past = System.currentTimeMillis() - animationStart;
        }
    }

    public void playSoundTrack() {
        this.soundTrack.play();
    }

    private void paintBomb1(int x, int y, int factor) {
        Color color = new Color(Math.min(255, factor), Math.max(0, factor - 256), 0);
        this.paintSquare(x, y, color);
    }

    private void paintBomb2(int x, int y, int factor) {
        if (factor > 127) {
            Color color = new Color(Math.min(255, Math.max(0, factor - 128)), Math.max(0, factor - 384), 0);
            this.paintSquare(x - 1, y, color);
            this.paintSquare(x + 1, y, color);
            this.paintSquare(x, y + 1, color);
            this.paintSquare(x, y - 1, color);
        }
    }

    private void paintBomb3(int x, int y, int factor) {
        if (factor > 255) {
            Color color = new Color(Math.max(0, factor - 256), 0, 0);
            this.paintSquare(x - 2, y, color);
            this.paintSquare(x + 2, y, color);
            this.paintSquare(x, y + 2, color);
            this.paintSquare(x, y - 2, color);
            this.paintSquare(x + 1, y + 1, color);
            this.paintSquare(x + 1, y - 1, color);
            this.paintSquare(x - 1, y + 1, color);
            this.paintSquare(x - 1, y - 1, color);
        }
    }

    private void paintSquare(int x, int y, Color color) {
        if (x >= 0 && x < 10 && y >= 0 && y < 18) {
            this.mainCanvas.paintSquare(x, y, color);
        }
    }

    public void showMessage(MessageLine[] messageLines, boolean clearBackground) {
        this.mainCanvas.showMessage(messageLines, clearBackground);
        this.nextPieceCanvas.paint();
    }

    public void reset() {
        this.inputHandler.reset();
        this.paintLabels();
        this.paintHighScores();
    }

    public boolean isLeftPressed() {
        return this.inputHandler.isLeftPressed() && !this.inputHandler.isRightPressed();
    }

    public boolean isRightPressed() {
        return this.inputHandler.isRightPressed() && !this.inputHandler.isLeftPressed();
    }

    public boolean isDownPressed() {
        return this.inputHandler.isDownPressed() && !this.inputHandler.isUpPressed();
    }

    public boolean isUpPressed() {
        return this.inputHandler.isUpPressed() && !this.inputHandler.isDownPressed();
    }

    private void configureWindow() {
        UIDefaults uiDefaults = UIManager.getDefaults();
        uiDefaults.put("Label.font", ((Font)uiDefaults.get("Label.font")).deriveFont(20.0f));
        uiDefaults.put("Panel.font", ((Font)uiDefaults.get("Label.font")).deriveFont(20.0f));
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(Icons.LETTRES_16);
        icons.add(Icons.LETTRES_32);
        this.setIconImages(icons);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                UserInterface.this.mainCanvas.requestFocus();
            }
        });
    }

    private void buildContentPanel(Container container) {
        Border panelsBorder = BorderFactory.createLineBorder(this.getBackground(), 5);
        CompoundBorder numbersBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createLineBorder(this.getBackground(), 3));
        this.mainCanvas = new MainCanvas(this.game, Color.BLACK);
        this.mainCanvas.addKeyListener(this.inputHandler);
        this.nextPieceCanvas = new NextPieceCanvas(this.game, this.getBackground());
        JLabel labelNext = new JLabel("Next", 2);
        JLabel labelLevel = new JLabel("Level", 2);
        JLabel labelLines = new JLabel("Lines", 2);
        JLabel labelScore = new JLabel("Score", 2);
        JLabel labelHiScores = new JLabel("High Scores", 2);
        this.level = new JLabel(this.formatNumber(this.game.getLevel()), 4);
        this.level.setBorder(numbersBorder);
        this.level.setOpaque(true);
        this.lines = new JLabel(this.formatNumber(this.game.getLines()), 4);
        this.lines.setBorder(numbersBorder);
        this.score = new JLabel(this.formatNumber(this.game.getScore()), 4);
        this.score.setBorder(numbersBorder);
        this.score.setOpaque(true);
        this.hiScoresName = new JLabel[5];
        this.hiScoresValue = new JLabel[5];
        for (int i = 0; i < 5; ++i) {
            this.hiScoresName[i] = new JLabel("", 2);
            this.hiScoresName[i].setForeground(this.getBackground().darker());
            this.hiScoresValue[i] = new JLabel("", 4);
            this.hiScoresValue[i].setForeground(this.hiScoresName[i].getForeground());
        }
        this.paintHighScores();
        JPanel canvasPanel = new JPanel(new FlowLayout(1, 0, 0));
        canvasPanel.setBorder(panelsBorder);
        canvasPanel.add(this.mainCanvas);
        JPanel hiScoresPanel = new JPanel(new GridLayout(5, 2, 1, 1));
        hiScoresPanel.setBorder(panelsBorder);
        for (int i = 0; i < 5; ++i) {
            hiScoresPanel.add(this.hiScoresName[i]);
            hiScoresPanel.add(this.hiScoresValue[i]);
        }
        JPanel infoPanel = new JPanel(new GridLayout(9, 1, 3, 3));
        infoPanel.setBorder(panelsBorder);
        infoPanel.add(labelNext);
        infoPanel.add(this.nextPieceCanvas);
        infoPanel.add(labelLevel);
        infoPanel.add(this.level);
        infoPanel.add(labelLines);
        infoPanel.add(this.lines);
        infoPanel.add(labelScore);
        infoPanel.add(this.score);
        infoPanel.add(labelHiScores);
        JPanel otherPanel = new JPanel(new BorderLayout());
        otherPanel.add((Component)infoPanel, "North");
        otherPanel.add((Component)hiScoresPanel, "Center");
        container.setLayout(new BorderLayout());
        container.add((Component)canvasPanel, "West");
        container.add((Component)otherPanel, "East");
    }

    private String formatNumber(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public String getHighScoreName() {
        String name = JOptionPane.showInputDialog(this, "Your name", null, -1);
        if (name == null || name.isEmpty()) {
            name = "...";
        }
        return name.substring(0, Math.min(5, name.length()));
    }
}

