/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.evertree.lettres.resource.Parameters;

public class ParametersDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private TableModel model;

    public ParametersDialog(JFrame owner) {
        super(owner, "Parameters", true);
        this.getContentPane().setLayout(new BorderLayout());
        Map<String, Object> parameters = Parameters.all;
        JTable table = new JTable(parameters.size(), 3);
        table.getColumnModel().getColumn(2).setMaxWidth(0);
        this.model = table.getModel();
        int i = 0;
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            this.model.setValueAt(key, i, 0);
            this.model.setValueAt(value, i, 1);
            this.model.setValueAt(value.getClass(), i++, 2);
        }
        this.getContentPane().add((Component)table, "North");
        JButton ok = new JButton("Ok");
        ok.addActionListener(this);
        this.getContentPane().add((Component)ok, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Map<String, Object> parameters = Parameters.all;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = null;
            String key = (String)this.model.getValueAt(i, 0);
            String string = String.valueOf(this.model.getValueAt(i, 1));
            Class type = (Class)this.model.getValueAt(i, 2);
            value = Long.class.equals((Object)type) ? new Long(string) : (Integer.class.equals((Object)type) ? new Integer(string) : string);
            parameters.put(key, value);
        }
        Parameters.update();
        this.dispose();
    }
}

