/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferStrategy;
import javax.swing.UIManager;
import org.evertree.lettres.Game;
import org.evertree.lettres.piece.Block;
import org.evertree.lettres.piece.Piece;
import org.evertree.lettres.resource.MessageLine;

public class MainCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    private static final Dimension CANVAS_DIMENSION = new Dimension(300, 540);
    private static final int BLOCK_WIDTH = 30;
    private static final int BLOCK_HEIGHT = 30;
    private Font blockFont;
    private BufferStrategy strategy;
    protected Game game;
    protected Color backgroundColor;

    public MainCanvas(Game game, Color backgroundColor) {
        this.game = game;
        this.backgroundColor = backgroundColor;
        this.blockFont = this.createFont();
        this.setLocation(0, 0);
        this.setSize(this.getCanvasDimension());
        this.setIgnoreRepaint(true);
    }

    public void paint() {
        Graphics2D g = (Graphics2D)this.getStrategy().getDrawGraphics();
        this.paintBackground(g);
        this.paintPiece(g, this.game.getDropping());
        this.paintDropped(g);
        g.dispose();
        this.getStrategy().show();
    }

    public void paintSquare(int x, int y, Color color) {
        Graphics2D g = (Graphics2D)this.getStrategy().getDrawGraphics();
        g.setColor(color);
        g.fillRect(x * this.getBlockWidth(), y * this.getBlockHeight(), this.getBlockWidth(), this.getBlockHeight());
        g.dispose();
        this.getStrategy().show();
    }

    public void showMessage(MessageLine[] messageLines, boolean clearBackground) {
        Graphics2D g = (Graphics2D)this.getStrategy().getDrawGraphics();
        if (clearBackground) {
            this.paintBackground(g);
        }
        int height = g.getFontMetrics().getHeight();
        int width = g.getFontMetrics().stringWidth("W");
        for (MessageLine line : messageLines) {
            g.setColor(line.getColor());
            g.drawString(line.getMessage(), width + line.getX() * width, height + line.getY() * height);
        }
        g.dispose();
        this.getStrategy().show();
    }

    protected void paintBackground(Graphics2D g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, MainCanvas.CANVAS_DIMENSION.width, MainCanvas.CANVAS_DIMENSION.height);
    }

    protected void paintPiece(Graphics2D g, Piece piece) {
        if (piece != null) {
            for (Block block : piece.getBlocks()) {
                this.paintBlock(g, block);
            }
        }
    }

    protected void paintDropped(Graphics2D g) {
        Block[][] blocks = this.game.getBlocks();
        for (int line = 0; line < blocks.length; ++line) {
            for (int column = 0; column < blocks[line].length; ++column) {
                this.paintBlock(g, blocks[line][column]);
            }
        }
    }

    protected void paintBlock(Graphics2D g, Block block) {
        if (block == null) {
            return;
        }
        g.setColor(block.getColor());
        g.fill3DRect(block.getX() * this.getBlockWidth(), block.getY() * this.getBlockHeight(), this.getBlockWidth(), this.getBlockHeight(), true);
        g.setColor(block.getFontColor());
        g.drawRect(block.getX() * this.getBlockWidth() + this.getBlockWidth() / 10 - 1, block.getY() * this.getBlockHeight() + this.getBlockHeight() / 10 - 1, this.getBlockWidth() - this.getBlockWidth() / 5, this.getBlockHeight() - this.getBlockHeight() / 5);
        g.setFont(this.blockFont);
        g.drawString(block.getLetter(), block.getX() * this.getBlockWidth() + (this.getBlockWidth() - g.getFontMetrics().stringWidth(block.getLetter())) / 2, (block.getY() + 1) * this.getBlockHeight() - this.getBlockHeight() / 4);
    }

    protected BufferStrategy getStrategy() {
        if (this.strategy == null) {
            this.createBufferStrategy(2);
            this.strategy = this.getBufferStrategy();
        }
        return this.strategy;
    }

    protected Dimension getCanvasDimension() {
        return CANVAS_DIMENSION;
    }

    protected int getBlockWidth() {
        return 30;
    }

    protected int getBlockHeight() {
        return 30;
    }

    protected Font createFont() {
        return ((Font)UIManager.getDefaults().get("Panel.font")).deriveFont((float)(this.getBlockHeight() / 3) * 2.0f);
    }
}

