/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.ui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.evertree.lettres.Game;

public class InputHandler
extends KeyAdapter {
    private Game game;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private boolean downPressed = false;
    private boolean upPressed = false;
    private StringBuffer letters;
    private long lastTyped = 0L;

    public InputHandler(Game game) {
        this.game = game;
        this.letters = new StringBuffer("XXXXXXXXXX");
    }

    public void reset() {
        this.leftPressed = false;
        this.rightPressed = false;
        this.downPressed = false;
        this.upPressed = false;
        this.lastTyped = 0L;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.game.getGameStatus() != Game.Status.PLAYING) {
            return;
        }
        if (e.getKeyCode() == 37) {
            this.leftPressed = true;
        }
        if (e.getKeyCode() == 39) {
            this.rightPressed = true;
        }
        if (e.getKeyCode() == 40) {
            this.downPressed = true;
        }
        if (e.getKeyCode() == 38) {
            this.upPressed = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.game.getGameStatus() != Game.Status.PLAYING) {
            return;
        }
        if (e.getKeyCode() == 37) {
            this.leftPressed = false;
        }
        if (e.getKeyCode() == 39) {
            this.rightPressed = false;
        }
        if (e.getKeyCode() == 40) {
            this.downPressed = false;
        }
        if (e.getKeyCode() == 38) {
            this.upPressed = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        long now;
        if (e.getKeyChar() == '\u001b') {
            this.game.exit();
        }
        if ((now = System.currentTimeMillis()) - this.lastTyped > 500L) {
            this.letters.replace(0, 10, "XXXXXXXXXX");
        }
        this.letters.insert(0, e.getKeyChar());
        this.letters.deleteCharAt(this.letters.length() - 1);
        this.lastTyped = now;
        this.game.wordTyped(this.letters.toString());
        if (this.game.getGameStatus() == Game.Status.PAUSED || this.game.getGameStatus() == Game.Status.PLAYING) {
            this.game.pause();
        } else if (this.game.getGameStatus() == Game.Status.WAITING || this.game.getGameStatus() == Game.Status.OVER) {
            this.game.startGame();
        }
    }

    public boolean isLeftPressed() {
        return this.leftPressed;
    }

    public boolean isRightPressed() {
        return this.rightPressed;
    }

    public boolean isDownPressed() {
        return this.downPressed;
    }

    public boolean isUpPressed() {
        return this.upPressed;
    }
}

