/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackListener;

public class SoundTrack {
    private File[] songs;
    private int index = 0;
    private SoundTrackThread player;

    public SoundTrack() {
        this.loadSongs();
    }

    public void play() {
        if (this.songs != null && this.songs.length > 0 && this.player == null) {
            this.player = new SoundTrackThread(this.songs[this.index]);
            this.player.start();
        }
    }

    public void nextSong() {
        if (this.songs != null && this.songs.length > 0) {
            this.index = (this.index + 1) % this.songs.length;
            this.player.end();
            this.player = null;
            this.play();
        }
    }

    public void stop() {
        if (this.songs != null && this.songs.length > 0) {
            this.player.end();
            this.player = null;
        }
    }

    public void reset() {
        this.index = 0;
    }

    private void loadSongs() {
        File mp3Dir = new File("mp3");
        if (mp3Dir.exists() && mp3Dir.isDirectory()) {
            this.songs = mp3Dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getAbsolutePath().endsWith(".mp3");
                }
            });
        }
    }

    class SoundTrackThread
    extends Thread {
        private AdvancedPlayer player;
        private File song;
        private boolean active = true;

        public SoundTrackThread(File song) {
            this.song = song;
        }

        @Override
        public void run() {
            while (this.active) {
                try {
                    this.playSong();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void playSong() throws Exception {
            this.player = new AdvancedPlayer(new FileInputStream(this.song));
            this.player.setPlayBackListener(new PlaybackListener(){});
            this.player.play();
        }

        public void end() {
            this.active = false;
            this.player.stop();
        }
    }
}

