/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class HighScores
implements Serializable {
    private static final String FILE_NAME = "hiscores.dat";
    private static final long serialVersionUID = 1L;
    public static final int LINES = 5;
    private static HighScores instance;
    private String[] names = new String[5];
    private long[] values = new long[5];

    public static HighScores load() {
        if (instance == null) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(FILE_NAME);
                ObjectInputStream obj_in = new ObjectInputStream(input);
                Object obj = obj_in.readObject();
                instance = (HighScores)obj;
            }
            catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) {
                    e.printStackTrace();
                }
                instance = new HighScores();
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return instance;
    }

    public void add(String name, long score) throws IOException {
        if (score <= this.values[4]) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (score <= this.values[i]) continue;
            String previousName = this.names[i];
            long previousValue = this.values[i];
            for (int j = i + 1; j < 5; ++j) {
                String auxName = this.names[j];
                long auxValue = this.values[j];
                this.names[j] = previousName;
                this.values[j] = previousValue;
                previousName = auxName;
                previousValue = auxValue;
            }
            this.names[i] = name;
            this.values[i] = score;
            break;
        }
        this.save();
    }

    public String[] getNames() {
        return this.names;
    }

    public long[] getValues() {
        return this.values;
    }

    private void save() throws IOException {
        File file = new File(FILE_NAME);
        FileOutputStream f_out = new FileOutputStream(file);
        ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
        obj_out.writeObject(this);
    }

    private HighScores() {
    }
}

