/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.resource;

import java.awt.Color;

public class BlockColor {
    private static final long serialVersionUID = 1L;
    private Color color;
    private double brightness = 0.0;
    private int deltaWhite;
    private int deltaBlack;

    public BlockColor(Color color) {
        this.color = color;
        this.calculateDeltas();
    }

    public Color getColor() {
        Color realColor = null;
        if (this.brightness == 0.0) {
            realColor = this.color;
        } else if (this.brightness > 0.0) {
            int factor = (int)((double)this.deltaWhite * this.brightness);
            int red = Math.min(255, this.color.getRed() + factor);
            int green = Math.min(255, this.color.getGreen() + factor);
            int blue = Math.min(255, this.color.getBlue() + factor);
            realColor = new Color(red, green, blue);
        } else {
            int factor = (int)((double)this.deltaBlack * this.brightness);
            int red = Math.max(0, this.color.getRed() + factor);
            int green = Math.max(0, this.color.getGreen() + factor);
            int blue = Math.max(0, this.color.getBlue() + factor);
            realColor = new Color(red, green, blue);
        }
        return realColor;
    }

    public void setBrightness(double brightness) {
        this.brightness = brightness;
    }

    private void calculateDeltas() {
        int lighterColor;
        this.deltaBlack = lighterColor = Math.max(this.color.getBlue(), Math.max(this.color.getRed(), this.color.getGreen()));
        int darkerColor = Math.min(this.color.getBlue(), Math.min(this.color.getRed(), this.color.getGreen()));
        this.deltaWhite = 255 - darkerColor;
    }
}

