/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.piece;

import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.evertree.lettres.Game;
import org.evertree.lettres.piece.Block;
import org.evertree.lettres.piece.PieceI;
import org.evertree.lettres.piece.PieceL;
import org.evertree.lettres.piece.PieceO;
import org.evertree.lettres.piece.PieceR;
import org.evertree.lettres.piece.PieceS;
import org.evertree.lettres.piece.PieceT;
import org.evertree.lettres.piece.PieceZ;

public abstract class Piece {
    protected int orientation;
    protected List<Block> blocks;
    private Block[][] space;
    private static final Random RANDOM = new Random();

    protected Piece() {
    }

    public static Piece create(Game game) {
        int n = RANDOM.nextInt(7);
        switch (n) {
            case 0: {
                return new PieceI();
            }
            case 1: {
                return new PieceO();
            }
            case 2: {
                return new PieceT();
            }
            case 3: {
                return new PieceL();
            }
            case 4: {
                return new PieceR();
            }
            case 5: {
                return new PieceZ();
            }
            case 6: {
                return new PieceS();
            }
        }
        return null;
    }

    public boolean moveDown() {
        return this.move(0, 1);
    }

    public boolean moveRight() {
        return this.move(1, 0);
    }

    public boolean moveLeft() {
        return this.move(-1, 0);
    }

    public boolean placeIn(Block[][] space, int x, int y) {
        int deltaY;
        int deltaX;
        if (this.blocks == null || this.blocks.isEmpty()) {
            return false;
        }
        int referenceX = (int)this.getLeftCorner().getX();
        int referenceY = (int)this.getLeftCorner().getY();
        for (Block block : this.blocks) {
            deltaX = block.getX() - referenceX;
            if (Block.canPlaceIn(space, x + deltaX, y + (deltaY = block.getY() - referenceY))) continue;
            return false;
        }
        this.space = space;
        for (Block block : this.blocks) {
            deltaX = block.getX() - referenceX;
            deltaY = block.getY() - referenceY;
            block.placeIn(space, x + deltaX, y + deltaY);
        }
        return true;
    }

    public boolean rotate() {
        int deltaY;
        int deltaX;
        this.moveOut();
        Point[][] deltas = this.getDeltas();
        int i = 0;
        boolean canPlace = true;
        for (Block block : this.blocks) {
            deltaX = deltas[this.orientation][i].x;
            deltaY = deltas[this.orientation][i].y;
            if (!Block.canPlaceIn(this.space, block.getX() + deltaX, block.getY() + deltaY)) {
                canPlace = false;
                break;
            }
            ++i;
        }
        i = 0;
        for (Block block : this.blocks) {
            deltaX = deltas[this.orientation][i].x;
            deltaY = deltas[this.orientation][i].y;
            if (canPlace) {
                block.placeIn(this.space, block.getX() + deltaX, block.getY() + deltaY);
            } else {
                block.placeIn(this.space, block.getX(), block.getY());
            }
            ++i;
        }
        if (canPlace) {
            this.orientation = (this.orientation + 1) % deltas.length;
        }
        return canPlace;
    }

    public List<Block> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    protected abstract Point[][] getDeltas();

    protected abstract Point getLeftCorner();

    protected boolean move(int deltaX, int deltaY) {
        if (this.space == null) {
            for (Block block : this.blocks) {
                block.move(deltaX, deltaY);
            }
            return true;
        }
        this.moveOut();
        boolean canPlace = true;
        for (Block block : this.blocks) {
            if (Block.canPlaceIn(this.space, block.getX() + deltaX, block.getY() + deltaY)) continue;
            canPlace = false;
            break;
        }
        for (Block block : this.blocks) {
            if (canPlace) {
                block.placeIn(this.space, block.getX() + deltaX, block.getY() + deltaY);
                continue;
            }
            block.placeIn(this.space, block.getX(), block.getY());
        }
        return canPlace;
    }

    protected void moveOut() {
        for (Block block : this.blocks) {
            block.moveOut();
        }
    }

    protected static Point p(int x, int y) {
        return new Point(x, y);
    }
}

