/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.piece;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.evertree.lettres.piece.Block;
import org.evertree.lettres.piece.GrayBlock;
import org.evertree.lettres.piece.Piece;

public class Blocks {
    private Block[][] array;

    public Blocks() {
        this.clear();
    }

    public void clear() {
        this.array = new Block[18][10];
    }

    public boolean place(int x, int y, Piece piece) {
        return piece.placeIn(this.array, x, y);
    }

    public Block[][] getBlocks() {
        return (Block[][])Arrays.copyOf(this.array, this.array.length);
    }

    public List<Integer> getFilledLines() {
        ArrayList<Integer> filledLines = new ArrayList<Integer>();
        for (int line = 0; line < this.array.length; ++line) {
            boolean free = false;
            for (Block block : this.array[line]) {
                if (block != null) continue;
                free = true;
                break;
            }
            if (free) continue;
            filledLines.add(line);
        }
        return filledLines;
    }

    public void removeLines(List<Integer> lines) {
        int line;
        int shift = 0;
        for (line = this.array.length - 1; line >= 0; --line) {
            int column;
            if (lines.contains(line)) {
                ++shift;
                for (column = 0; column < this.array[line].length; ++column) {
                    if (this.array[line][column] == null) continue;
                    this.array[line][column].moveOut();
                }
                continue;
            }
            for (column = 0; column < this.array[line].length; ++column) {
                Block block = this.array[line][column];
                if (block == null) continue;
                block.moveTo(block.getX(), block.getY() + shift);
            }
        }
        for (line = 0; line < shift; ++line) {
            this.array[line] = new Block[this.array[0].length];
        }
    }

    public void insertGrayLine(int line, int blankColumn) {
        this.removeLines(Collections.singletonList(0));
        for (int row = 1; row <= line; ++row) {
            for (int column = 0; column < this.array[0].length; ++column) {
                if (this.array[row][column] == null) continue;
                this.array[row][column].moveUp();
            }
        }
        for (int column = 0; column < this.array[0].length; ++column) {
            if (column == blankColumn) continue;
            GrayBlock grayBlock = new GrayBlock();
            grayBlock.placeIn(this.array, column, line);
        }
    }

    public void draw(Color[][] blocks) {
        for (int row = 0; row < blocks.length; ++row) {
            for (int column = 0; column < blocks[0].length; ++column) {
                if (blocks[row][column] == null) continue;
                new Block(0, 0, blocks[row][column]).placeIn(this.array, column, row);
            }
        }
    }

    public Block forceGrayBlock(int x, int y) {
        if (this.array[y][x] != null) {
            this.array[y][x].moveOut();
        }
        GrayBlock block = new GrayBlock();
        block.placeIn(this.array, x, y);
        return block;
    }

    public void remove(int x, int y) {
        if (x >= 0 && x < this.array[0].length && y >= 0 && y < this.array.length && this.array[y][x] != null) {
            this.array[y][x].moveOut();
        }
    }
}

