/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.piece;

import java.awt.Color;
import org.evertree.lettres.action.LetterSource;
import org.evertree.lettres.resource.BlockColor;

public class Block {
    private int x = 0;
    private int y = 0;
    private BlockColor color;
    private BlockColor fontColor;
    protected String letter;
    private Block[][] space;

    public Block(int x, int y, Color color) {
        this.x = x;
        this.y = y;
        this.color = new BlockColor(color);
        this.fontColor = new BlockColor(color.brighter().brighter());
        this.letter = LetterSource.getLetter();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Color getColor() {
        return this.color.getColor();
    }

    public void setBrightness(double brightness) {
        this.color.setBrightness(brightness);
    }

    public Color getFontColor() {
        return this.fontColor.getColor();
    }

    public void setFontBrightness(double brightness) {
        this.fontColor.setBrightness(brightness);
    }

    public String getLetter() {
        return this.letter;
    }

    public boolean isInTheSameSpace(Block other) {
        return this.space == other.space;
    }

    protected boolean moveUp() {
        return this.moveTo(this.x, this.y - 1);
    }

    protected boolean moveDown() {
        return this.moveTo(this.x, this.y + 1);
    }

    protected boolean moveLeft() {
        return this.moveTo(this.x - 1, this.y);
    }

    protected boolean moveRight() {
        return this.moveTo(this.x + 1, this.y);
    }

    protected boolean moveTo(int newX, int newY) {
        if (this.canMove(newX, newY)) {
            if (this.space != null) {
                this.space[this.y][this.x] = null;
            }
            this.x = newX;
            this.y = newY;
            if (this.space != null) {
                this.space[newY][newX] = this;
            }
            return true;
        }
        return false;
    }

    protected boolean move(int deltaX, int deltaY) {
        return this.moveTo(this.x + deltaX, this.y + deltaY);
    }

    protected boolean canMove(int newX, int newY) {
        return Block.canPlaceIn(this.space, newX, newY);
    }

    protected static boolean canPlaceIn(Block[][] newSpace, int newX, int newY) {
        if (newSpace == null) {
            return true;
        }
        return newY >= 0 && newY < newSpace.length && newX >= 0 && newX < newSpace[0].length && newSpace[newY][newX] == null;
    }

    protected boolean placeIn(Block[][] newSpace, int newX, int newY) {
        if (Block.canPlaceIn(newSpace, newX, newY)) {
            if (this.space != null) {
                this.space[this.y][this.x] = null;
            }
            this.space = newSpace;
            this.x = newX;
            this.y = newY;
            this.space[newY][newX] = this;
            return true;
        }
        return false;
    }

    protected void moveOut() {
        if (this.space != null) {
            this.space[this.y][this.x] = null;
            this.space = null;
        }
    }

    public String toString() {
        return "[" + this.letter + "]";
    }
}

