/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.evertree.lettres.action.HorizontalWord;
import org.evertree.lettres.action.VerticalWord;
import org.evertree.lettres.action.Word;
import org.evertree.lettres.piece.Block;

public final class WordFinder {
    private List<Word> currentWords;
    private Set<String> words;

    public WordFinder(Set<String> words) {
        this.words = words;
        this.currentWords = new ArrayList<Word>();
    }

    public Word findNewWord(Block[][] blocks) {
        Word word = this.findNewHorizontalWord(blocks);
        if (word == null) {
            word = this.findNewVerticalWord(blocks);
        }
        return word;
    }

    private Word findNewHorizontalWord(Block[][] blocks) {
        for (int row = 0; row < blocks.length; ++row) {
            StringBuilder letters = new StringBuilder();
            for (int column = 0; column < blocks[0].length; ++column) {
                Block block = blocks[row][column];
                if (block != null) {
                    letters.append(block.getLetter());
                    continue;
                }
                letters.append(" ");
            }
            if (letters.toString().trim().length() <= 0) continue;
            for (String word : this.words) {
                int begin = 0;
                int index = 0;
                index = letters.toString().indexOf(word, begin);
                while (index > -1) {
                    Block[] wordBlocks = new Block[word.length()];
                    for (int i = 0; i < wordBlocks.length; ++i) {
                        wordBlocks[i] = blocks[row][index + i];
                    }
                    HorizontalWord foundWord = new HorizontalWord(word, wordBlocks);
                    if (!this.isCurrentWord(foundWord)) {
                        this.currentWords.add(foundWord);
                        return foundWord;
                    }
                    begin = index + 1;
                    index = letters.toString().indexOf(word, begin);
                }
            }
        }
        return null;
    }

    private Word findNewVerticalWord(Block[][] blocks) {
        for (int column = 0; column < blocks[0].length; ++column) {
            StringBuilder letters = new StringBuilder();
            for (int row = 0; row < blocks.length; ++row) {
                Block block = blocks[row][column];
                if (block != null) {
                    letters.append(block.getLetter());
                    continue;
                }
                letters.append(" ");
            }
            if (letters.toString().trim().length() <= 0) continue;
            for (String word : this.words) {
                int begin = 0;
                int index = 0;
                index = letters.toString().indexOf(word, begin);
                while (index > -1) {
                    Block[] wordBlocks = new Block[word.length()];
                    for (int i = 0; i < wordBlocks.length; ++i) {
                        wordBlocks[i] = blocks[index + i][column];
                    }
                    VerticalWord foundWord = new VerticalWord(word, wordBlocks);
                    if (!this.isCurrentWord(foundWord)) {
                        this.currentWords.add(foundWord);
                        return foundWord;
                    }
                    begin = index + 1;
                    index = letters.toString().indexOf(word, begin);
                }
            }
        }
        return null;
    }

    private boolean isCurrentWord(Word word) {
        Iterator<Word> iterator = this.currentWords.iterator();
        while (iterator.hasNext()) {
            Word current = iterator.next();
            if (!current.validate()) {
                iterator.remove();
                continue;
            }
            if (!current.equals(word)) continue;
            return true;
        }
        return false;
    }
}

