/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.evertree.lettres.Game;
import org.evertree.lettres.action.Action;
import org.evertree.lettres.resource.Icons;

public class ListActionsAction
extends Action {
    private Game game;

    public ListActionsAction(Game game) {
        this.game = game;
    }

    @Override
    public void execute() {
        JDialog window = this.createWindow();
        window.setVisible(true);
    }

    private JDialog createWindow() {
        Set<String> actionNames = this.game.getActionNames();
        final JDialog window = new JDialog(this.game.getUserInterface(), "Lettres", true);
        window.setIconImage(Icons.LETTRES_16);
        window.setSize(250, 500);
        window.setResizable(false);
        window.setLocationRelativeTo(null);
        ((JPanel)window.getContentPane()).setBorder(BorderFactory.createLineBorder(window.getBackground(), 5));
        ((BorderLayout)window.getContentPane().getLayout()).setVgap(5);
        JPanel listPanel = new JPanel(new GridLayout(actionNames.size(), 1, 5, 5));
        for (String actionName : actionNames) {
            listPanel.add(new JLabel(" " + actionName));
        }
        JScrollPane scroller = new JScrollPane(listPanel);
        JButton button = new JButton("CLOSE");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.dispose();
            }
        });
        window.add((Component)new JLabel("The possible words are:"), "North");
        window.add((Component)scroller, "Center");
        window.add((Component)button, "South");
        return window;
    }
}

