/*
 * Decompiled with CFR 0.152.
 */
package org.evertree.lettres;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evertree.lettres.AddLineAction;
import org.evertree.lettres.AddScoreAction;
import org.evertree.lettres.BombAction;
import org.evertree.lettres.BrazilAction;
import org.evertree.lettres.ChangeSpeedAction;
import org.evertree.lettres.ClearBlocksAction;
import org.evertree.lettres.EndGameAction;
import org.evertree.lettres.ListActionsAction;
import org.evertree.lettres.MultiplyScoreAction;
import org.evertree.lettres.TetrisAction;
import org.evertree.lettres.action.Action;
import org.evertree.lettres.action.LetterSource;
import org.evertree.lettres.action.Word;
import org.evertree.lettres.action.WordFinder;
import org.evertree.lettres.piece.Block;
import org.evertree.lettres.piece.Blocks;
import org.evertree.lettres.piece.Piece;
import org.evertree.lettres.resource.HighScores;
import org.evertree.lettres.resource.MessageLine;
import org.evertree.lettres.resource.Parameters;
import org.evertree.lettres.ui.ParametersDialog;
import org.evertree.lettres.ui.UserInterface;

public class Game
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ROWS = 18;
    public static final int COLUMNS = 10;
    private long lastDrop = 0L;
    private long lastVerticalMove = 0L;
    private long lastHorizontalMove = 0L;
    private Status gameStatus = Status.WAITING;
    private Piece next = null;
    private Piece dropping = null;
    private Blocks blocks = new Blocks();
    private WordFinder wordFinder;
    private long dropInterval;
    private long level;
    private long lines;
    private long score;
    private HighScores highScores = HighScores.load();
    private UserInterface userInterface = new UserInterface(this);
    private Map<String, Action> actions;

    public Game() {
        this.loadActions();
        LetterSource.load(this.actions.keySet());
        this.wordFinder = new WordFinder(this.actions.keySet());
    }

    public void startGame() {
        this.dropping = null;
        this.level = 1L;
        this.lines = 0L;
        this.score = 0L;
        this.dropInterval = Parameters.INITIAL_DROP_INTERVAL;
        this.lastDrop = 0L;
        this.lastHorizontalMove = 0L;
        this.lastVerticalMove = 0L;
        this.userInterface.reset();
        this.userInterface.playSoundTrack();
        this.blocks.clear();
        this.gameStatus = Status.PLAYING;
    }

    public void pause() {
        this.gameStatus = this.gameStatus == Status.PAUSED ? Status.PLAYING : Status.PAUSED;
    }

    public void exit() {
        System.exit(0);
    }

    public void wordTyped(String word) {
        if (word.indexOf("olecram") > -1) {
            if (this.gameStatus != Status.PAUSED) {
                this.pause();
            }
            new ParametersDialog(this.userInterface);
            this.pause();
        }
    }

    public HighScores getHighScores() {
        return this.highScores;
    }

    public Status getGameStatus() {
        return this.gameStatus;
    }

    public Piece getDropping() {
        return this.dropping;
    }

    public long getLevel() {
        return this.level;
    }

    public long getLines() {
        return this.lines;
    }

    public long getScore() {
        return this.score;
    }

    public Piece getNext() {
        return this.next;
    }

    public Block[][] getBlocks() {
        return this.blocks.getBlocks();
    }

    Set<String> getActionNames() {
        return this.actions.keySet();
    }

    UserInterface getUserInterface() {
        return this.userInterface;
    }

    void endGame() {
        this.userInterface.playGameOver();
        this.gameStatus = Status.OVER;
        this.dropping = null;
        this.addToHighScores();
        this.userInterface.paintHighScores();
    }

    void addScore(long score) {
        this.score += score;
        this.userInterface.paintLabels();
    }

    void removeLines(List<Integer> lines) {
        switch (lines.size()) {
            case 1: {
                this.addScore(Parameters.ONE_LINE_FILLED_SCORE);
                break;
            }
            case 2: {
                this.addScore(Parameters.TWO_LINE_FILLED_SCORE);
                break;
            }
            case 3: {
                this.addScore(Parameters.THREE_LINE_FILLED_SCORE);
                break;
            }
            case 4: {
                this.addScore(Parameters.FOUR_LINE_FILLED_SCORE);
                break;
            }
        }
        this.addLines(lines.size());
        this.userInterface.playDeleteLines(lines);
        this.blocks.removeLines(lines);
    }

    Blocks getRealBlocks() {
        return this.blocks;
    }

    void setDropInterval(long dropInterval) {
        this.dropInterval = dropInterval;
    }

    void checkFilledLines() {
        List<Integer> lines = this.blocks.getFilledLines();
        if (!lines.isEmpty()) {
            this.removeLines(lines);
            this.userInterface.reset();
        }
    }

    private void gameLoop() {
        while (true) {
            if (this.gameStatus == Status.PLAYING) {
                if (this.dropPiece()) {
                    this.moveLeft();
                    this.moveRight();
                    this.moveDown();
                    this.rotate();
                    this.userInterface.paint();
                }
            } else if (this.gameStatus == Status.OVER) {
                this.userInterface.showMessage(MessageLine.MESSAGE_GAME_OVER, false);
            } else if (this.gameStatus == Status.WAITING) {
                this.userInterface.showMessage(MessageLine.MESSAGE_INTRO, true);
            } else if (this.gameStatus == Status.PAUSED) {
                this.userInterface.showMessage(MessageLine.MESSAGE_PAUSED, true);
            }
            try {
                Thread.sleep(1000 / Parameters.FPS);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private Piece consumeNext() {
        Piece piece = null;
        if (this.next == null) {
            this.next = Piece.create(this);
        }
        piece = this.next;
        this.next = Piece.create(this);
        return piece;
    }

    private boolean dropPiece() {
        if (this.dropping == null) {
            this.lastDrop = System.currentTimeMillis();
            this.dropping = this.consumeNext();
            if (!this.blocks.place(3, 0, this.dropping)) {
                this.endGame();
                return false;
            }
        } else {
            if (System.currentTimeMillis() - this.lastDrop < this.dropInterval) {
                return true;
            }
            this.lastDrop = System.currentTimeMillis();
            if (!this.dropping.moveDown()) {
                this.droppingHitFloor();
                return false;
            }
        }
        return true;
    }

    private void droppingHitFloor() {
        this.dropping = null;
        this.checkWord();
        this.checkFilledLines();
        this.checkWord();
        this.userInterface.reset();
    }

    private void checkWord() {
        Word word = this.wordFinder.findNewWord(this.getBlocks());
        while (word != null) {
            this.userInterface.playWordAnimation(word.getBlocks());
            Action action = this.actions.get(word.getWord());
            action.execute(word.getBlocks());
            word = this.wordFinder.findNewWord(this.getBlocks());
        }
    }

    private void addLines(int lines) {
        this.lines += (long)lines;
        this.setLevel(this.lines / (long)Parameters.LINES_PER_LEVEL.intValue() + 1L);
        this.userInterface.paintLabels();
    }

    private void setLevel(long level) {
        if (this.level != level) {
            this.userInterface.playLevelUp();
            this.level = level;
            this.dropInterval -= Parameters.DROP_INTERVAL_DECREMENT.longValue();
        }
    }

    private void moveLeft() {
        if (this.dropping != null && this.userInterface.isLeftPressed()) {
            if (System.currentTimeMillis() - this.lastHorizontalMove < Parameters.MOVE_HORIZONTAL_INTERVAL) {
                return;
            }
            this.dropping.moveLeft();
            this.lastHorizontalMove = System.currentTimeMillis();
        }
    }

    private void moveRight() {
        if (this.dropping != null && this.userInterface.isRightPressed()) {
            if (System.currentTimeMillis() - this.lastHorizontalMove < Parameters.MOVE_HORIZONTAL_INTERVAL) {
                return;
            }
            this.dropping.moveRight();
            this.lastHorizontalMove = System.currentTimeMillis();
        }
    }

    private void moveDown() {
        if (this.dropping != null && this.userInterface.isDownPressed()) {
            if (System.currentTimeMillis() - this.lastVerticalMove < Parameters.MOVE_VERTICAL_INTERVAL) {
                return;
            }
            this.lastVerticalMove = System.currentTimeMillis();
            if (!this.dropping.moveDown()) {
                this.droppingHitFloor();
            }
        }
    }

    private void rotate() {
        if (this.dropping != null && this.userInterface.isUpPressed()) {
            if (System.currentTimeMillis() - this.lastVerticalMove < Parameters.MOVE_HORIZONTAL_INTERVAL) {
                return;
            }
            this.dropping.rotate();
            this.lastVerticalMove = System.currentTimeMillis();
        }
    }

    private void loadActions() {
        this.actions = new HashMap<String, Action>();
        this.actions.put("DOUBLE", new MultiplyScoreAction(this, 2));
        this.actions.put("TRIPLE", new MultiplyScoreAction(this, 3));
        this.actions.put("LIST", new ListActionsAction(this));
        this.actions.put("MCL", new AddScoreAction(this, 1150L));
        this.actions.put("LETTRES", new AddScoreAction(this, 1000000L));
        this.actions.put("CLEAR", new ClearBlocksAction(this));
        this.actions.put("LINES", new AddLineAction(this, 4));
        this.actions.put("FAST", new ChangeSpeedAction(this, Parameters.INITIAL_DROP_INTERVAL / 2L));
        this.actions.put("SLOW", new ChangeSpeedAction(this, Parameters.INITIAL_DROP_INTERVAL * 2L));
        this.actions.put("GAMEOVER", new EndGameAction(this));
        this.actions.put("BRAZIL", new BrazilAction(this));
        this.actions.put("TETRIS", new TetrisAction(this));
        this.actions.put("BOMB", new BombAction(this));
    }

    private boolean addToHighScores() {
        if (this.highScores.getValues()[4] < this.score) {
            try {
                this.highScores.add(this.userInterface.getHighScoreName(), this.score);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Game l = new Game();
        l.gameLoop();
    }

    public static enum Status {
        WAITING,
        PLAYING,
        PAUSED,
        OVER;

    }
}

